/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.lighting.LC;
import cofh.repack.codechicken.lib.lighting.LightModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import cofh.repack.codechicken.lib.render.uv.UVTranslation;
import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.RedundantTransformation;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.TransformationList;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CCModel
implements CCRenderState.IVertexSource,
Copyable<CCModel> {
    public final int vertexMode;
    public final int vp;
    public Vertex5[] verts;
    public ArrayList<Object> attributes = new ArrayList();
    private static final Pattern vertPattern = Pattern.compile("v(?: ([\\d\\.+-]+))+");
    private static final Pattern uvwPattern = Pattern.compile("vt(?: ([\\d\\.+-]+))+");
    private static final Pattern normalPattern = Pattern.compile("vn(?: ([\\d\\.+-]+))+");
    private static final Pattern polyPattern = Pattern.compile("f(?: ((?:\\d*)(?:/\\d*)?(?:/\\d*)?))+");
    public static final Matcher vertMatcher = vertPattern.matcher("");
    public static final Matcher uvwMatcher = uvwPattern.matcher("");
    public static final Matcher normalMatcher = normalPattern.matcher("");
    public static final Matcher polyMatcher = polyPattern.matcher("");

    protected CCModel(int n) {
        if (n != 7 && n != 4) {
            throw new IllegalArgumentException("Models must be GL_QUADS or GL_TRIANGLES");
        }
        this.vertexMode = n;
        this.vp = n == 7 ? 4 : 3;
    }

    public Vector3[] normals() {
        return this.getAttributes(CCRenderState.normalAttrib);
    }

    @Override
    public Vertex5[] getVertices() {
        return this.verts;
    }

    @Override
    public <T> T getAttributes(CCRenderState.VertexAttribute<T> vertexAttribute) {
        if (vertexAttribute.attributeIndex < this.attributes.size()) {
            return (T)this.attributes.get(vertexAttribute.attributeIndex);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(CCRenderState.VertexAttribute<?> vertexAttribute) {
        return vertexAttribute.attributeIndex < this.attributes.size() && this.attributes.get(vertexAttribute.attributeIndex) != null;
    }

    @Override
    public void prepareVertex() {
    }

    public <T> T getOrAllocate(CCRenderState.VertexAttribute<T> vertexAttribute) {
        T t = this.getAttributes(vertexAttribute);
        if (t == null) {
            while (this.attributes.size() <= vertexAttribute.attributeIndex) {
                this.attributes.add(null);
            }
            t = vertexAttribute.newArray(this.verts.length);
            this.attributes.set(vertexAttribute.attributeIndex, t);
        }
        return t;
    }

    public CCModel generateBox(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12 = d + d4;
        double d13 = d2 + d5;
        double d14 = d3 + d6;
        d /= d11;
        d12 /= d11;
        d2 /= d11;
        d13 /= d11;
        d3 /= d11;
        double d15 = (d7 + d6 + d4) / d9;
        double d16 = (d8 + d6) / d10;
        double d17 = (d7 + d6 * 2.0 + d4) / d9;
        double d18 = d8 / d10;
        this.verts[n++] = new Vertex5(d, d2, d14 /= d11, d15, d18);
        this.verts[n++] = new Vertex5(d, d2, d3, d15, d16);
        this.verts[n++] = new Vertex5(d12, d2, d3, d17, d16);
        this.verts[n++] = new Vertex5(d12, d2, d14, d17, d18);
        d15 = (d7 + d6) / d9;
        d16 = (d8 + d6) / d10;
        d17 = (d7 + d6 + d4) / d9;
        d18 = d8 / d10;
        this.verts[n++] = new Vertex5(d12, d13, d14, d17, d18);
        this.verts[n++] = new Vertex5(d12, d13, d3, d17, d16);
        this.verts[n++] = new Vertex5(d, d13, d3, d15, d16);
        this.verts[n++] = new Vertex5(d, d13, d14, d15, d18);
        d15 = (d7 + d6 + d4) / d9;
        d16 = (d8 + d6) / d10;
        d17 = (d7 + d6) / d9;
        d18 = (d8 + d6 + d5) / d10;
        this.verts[n++] = new Vertex5(d, d13, d3, d17, d16);
        this.verts[n++] = new Vertex5(d12, d13, d3, d15, d16);
        this.verts[n++] = new Vertex5(d12, d2, d3, d15, d18);
        this.verts[n++] = new Vertex5(d, d2, d3, d17, d18);
        d15 = (d7 + d6 * 2.0 + d4 * 2.0) / d9;
        d16 = (d8 + d6) / d10;
        d17 = (d7 + d6 * 2.0 + d4) / d9;
        d18 = (d8 + d6 + d5) / d10;
        this.verts[n++] = new Vertex5(d, d13, d14, d15, d16);
        this.verts[n++] = new Vertex5(d, d2, d14, d15, d18);
        this.verts[n++] = new Vertex5(d12, d2, d14, d17, d18);
        this.verts[n++] = new Vertex5(d12, d13, d14, d17, d16);
        d15 = (d7 + d6) / d9;
        d16 = (d8 + d6) / d10;
        d17 = d7 / d9;
        d18 = (d8 + d6 + d5) / d10;
        this.verts[n++] = new Vertex5(d, d13, d14, d17, d16);
        this.verts[n++] = new Vertex5(d, d13, d3, d15, d16);
        this.verts[n++] = new Vertex5(d, d2, d3, d15, d18);
        this.verts[n++] = new Vertex5(d, d2, d14, d17, d18);
        d15 = (d7 + d6 * 2.0 + d4) / d9;
        d16 = (d8 + d6) / d10;
        d17 = (d7 + d6 + d4) / d9;
        d18 = (d8 + d6 + d5) / d10;
        this.verts[n++] = new Vertex5(d12, d2, d14, d15, d18);
        this.verts[n++] = new Vertex5(d12, d2, d3, d17, d18);
        this.verts[n++] = new Vertex5(d12, d13, d3, d17, d16);
        this.verts[n++] = new Vertex5(d12, d13, d14, d15, d16);
        return this;
    }

    public CCModel generateBlock(int n, Cuboid6 cuboid6) {
        return this.generateBlock(n, cuboid6, 0);
    }

    public CCModel generateBlock(int n, Cuboid6 cuboid6, int n2) {
        return this.generateBlock(n, cuboid6.min.x, cuboid6.min.y, cuboid6.min.z, cuboid6.max.x, cuboid6.max.y, cuboid6.max.z, n2);
    }

    public CCModel generateBlock(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        return this.generateBlock(n, d, d2, d3, d4, d5, d6, 0);
    }

    public CCModel generateBlock(int n, double d, double d2, double d3, double d4, double d5, double d6, int n2) {
        double d7;
        double d8;
        double d9;
        double d10;
        if ((n2 & 1) == 0) {
            d10 = d;
            d9 = d3;
            d8 = d4;
            d7 = d6;
            this.verts[n++] = new Vertex5(d, d2, d6, d10, d7, 0);
            this.verts[n++] = new Vertex5(d, d2, d3, d10, d9, 0);
            this.verts[n++] = new Vertex5(d4, d2, d3, d8, d9, 0);
            this.verts[n++] = new Vertex5(d4, d2, d6, d8, d7, 0);
        }
        if ((n2 & 2) == 0) {
            d10 = d;
            d9 = d3;
            d8 = d4;
            d7 = d6;
            this.verts[n++] = new Vertex5(d4, d5, d6, d8, d7, 1);
            this.verts[n++] = new Vertex5(d4, d5, d3, d8, d9, 1);
            this.verts[n++] = new Vertex5(d, d5, d3, d10, d9, 1);
            this.verts[n++] = new Vertex5(d, d5, d6, d10, d7, 1);
        }
        if ((n2 & 4) == 0) {
            d10 = 1.0 - d;
            d9 = 1.0 - d5;
            d8 = 1.0 - d4;
            d7 = 1.0 - d2;
            this.verts[n++] = new Vertex5(d, d2, d3, d10, d7, 2);
            this.verts[n++] = new Vertex5(d, d5, d3, d10, d9, 2);
            this.verts[n++] = new Vertex5(d4, d5, d3, d8, d9, 2);
            this.verts[n++] = new Vertex5(d4, d2, d3, d8, d7, 2);
        }
        if ((n2 & 8) == 0) {
            d10 = d;
            d9 = 1.0 - d5;
            d8 = d4;
            d7 = 1.0 - d2;
            this.verts[n++] = new Vertex5(d4, d2, d6, d8, d7, 3);
            this.verts[n++] = new Vertex5(d4, d5, d6, d8, d9, 3);
            this.verts[n++] = new Vertex5(d, d5, d6, d10, d9, 3);
            this.verts[n++] = new Vertex5(d, d2, d6, d10, d7, 3);
        }
        if ((n2 & 0x10) == 0) {
            d10 = d3;
            d9 = 1.0 - d5;
            d8 = d6;
            d7 = 1.0 - d2;
            this.verts[n++] = new Vertex5(d, d2, d6, d8, d7, 4);
            this.verts[n++] = new Vertex5(d, d5, d6, d8, d9, 4);
            this.verts[n++] = new Vertex5(d, d5, d3, d10, d9, 4);
            this.verts[n++] = new Vertex5(d, d2, d3, d10, d7, 4);
        }
        if ((n2 & 0x20) == 0) {
            d10 = 1.0 - d3;
            d9 = 1.0 - d5;
            d8 = 1.0 - d6;
            d7 = 1.0 - d2;
            this.verts[n++] = new Vertex5(d4, d2, d3, d10, d7, 5);
            this.verts[n++] = new Vertex5(d4, d5, d3, d10, d9, 5);
            this.verts[n++] = new Vertex5(d4, d5, d6, d8, d9, 5);
            this.verts[n++] = new Vertex5(d4, d2, d6, d8, d7, 5);
        }
        return this;
    }

    public CCModel computeNormals() {
        return this.computeNormals(0, this.verts.length);
    }

    public CCModel computeNormals(int n, int n2) {
        if (n2 % this.vp != 0 || n % this.vp != 0) {
            throw new IllegalArgumentException("Cannot generate normals across polygons");
        }
        Vector3[] vector3Array = this.getOrAllocate(CCRenderState.normalAttrib);
        for (int i = 0; i < n2; i += this.vp) {
            int n3 = i + n;
            Vector3 vector3 = this.verts[n3 + 1].vec.copy().subtract(this.verts[n3].vec);
            Vector3 vector32 = this.verts[n3 + this.vp - 1].vec.copy().subtract(this.verts[n3].vec);
            vector3Array[n3] = vector3.crossProduct(vector32).normalize();
            for (int j = 1; j < this.vp; ++j) {
                vector3Array[n3 + j] = vector3Array[n3].copy();
            }
        }
        return this;
    }

    public CCModel computeLighting(LightModel lightModel) {
        Vector3[] vector3Array = this.normals();
        int[] nArray = this.getAttributes(CCRenderState.lightingAttrib);
        if (nArray == null) {
            nArray = this.getOrAllocate(CCRenderState.lightingAttrib);
            Arrays.fill(nArray, -1);
        }
        for (int i = 0; i < this.verts.length; ++i) {
            nArray[i] = lightModel.apply(nArray[i], vector3Array[i]);
        }
        return this;
    }

    public CCModel setColour(int n) {
        int[] nArray = this.getOrAllocate(CCRenderState.colourAttrib);
        Arrays.fill(nArray, n);
        return this;
    }

    public CCModel computeLightCoords() {
        LC[] lCArray = this.getOrAllocate(CCRenderState.lightCoordAttrib);
        Vector3[] vector3Array = this.normals();
        for (int i = 0; i < this.verts.length; ++i) {
            lCArray[i] = new LC().compute(this.verts[i].vec, vector3Array[i]);
        }
        return this;
    }

    public CCModel smoothNormals() {
        ArrayList<PositionNormalEntry> arrayList = new ArrayList<PositionNormalEntry>();
        Vector3[] vector3Array = this.normals();
        block0: for (int i = 0; i < this.verts.length; ++i) {
            Vector3 object = this.verts[i].vec;
            for (PositionNormalEntry positionNormalEntry : arrayList) {
                if (!positionNormalEntry.positionEqual(object)) continue;
                positionNormalEntry.addNormal(vector3Array[i]);
                continue block0;
            }
            arrayList.add(new PositionNormalEntry(object).addNormal(vector3Array[i]));
        }
        for (PositionNormalEntry positionNormalEntry : arrayList) {
            if (positionNormalEntry.normals.size() <= 1) continue;
            Vector3 vector3 = new Vector3();
            for (Vector3 vector32 : positionNormalEntry.normals) {
                vector3.add(vector32);
            }
            vector3.normalize();
            for (Vector3 vector32 : positionNormalEntry.normals) {
                vector32.set(vector3);
            }
        }
        return this;
    }

    public CCModel apply(Transformation transformation) {
        for (int i = 0; i < this.verts.length; ++i) {
            this.verts[i].apply(transformation);
        }
        Vector3[] vector3Array = this.normals();
        if (vector3Array != null) {
            for (int i = 0; i < vector3Array.length; ++i) {
                transformation.applyN(vector3Array[i]);
            }
        }
        return this;
    }

    public CCModel apply(UVTransformation uVTransformation) {
        for (int i = 0; i < this.verts.length; ++i) {
            this.verts[i].apply(uVTransformation);
        }
        return this;
    }

    public CCModel expand(int n) {
        int n2 = this.verts.length + n;
        this.verts = Arrays.copyOf(this.verts, n2);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i) == null) continue;
            this.attributes.set(i, CCRenderState.copyOf(CCRenderState.getAttribute(i), this.attributes.get(i), n2));
        }
        return this;
    }

    public void render(double d, double d2, double d3, double d4, double d5) {
        this.render(new Vector3(d, d2, d3).translation(), new UVTranslation(d4, d5));
    }

    public void render(double d, double d2, double d3, UVTransformation uVTransformation) {
        this.render(new Vector3(d, d2, d3).translation(), uVTransformation);
    }

    public void render(Transformation transformation, double d, double d2) {
        this.render(transformation, new UVTranslation(d, d2));
    }

    public void render(CCRenderState.IVertexOperation ... iVertexOperationArray) {
        this.render(0, this.verts.length, iVertexOperationArray);
    }

    public void render(int n, int n2, CCRenderState.IVertexOperation ... iVertexOperationArray) {
        CCRenderState.setPipeline(this, n, n2, iVertexOperationArray);
        CCRenderState.render();
    }

    public static CCModel quadModel(int n) {
        return CCModel.newModel(7, n);
    }

    public static CCModel triModel(int n) {
        return CCModel.newModel(4, n);
    }

    public static CCModel newModel(int n, int n2) {
        CCModel cCModel = CCModel.newModel(n);
        cCModel.verts = new Vertex5[n2];
        return cCModel;
    }

    public static CCModel newModel(int n) {
        return new CCModel(n);
    }

    public static double[] parseDoubles(String string, String string2) {
        String[] stringArray = string.split(string2);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public static void illegalAssert(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void assertMatch(Matcher matcher, String string) {
        matcher.reset(string);
        CCModel.illegalAssert(matcher.matches(), "Malformed line: " + string);
    }

    public static Map<String, CCModel> parseObjModels(InputStream inputStream, int n, Transformation transformation) throws IOException {
        String string;
        if (transformation == null) {
            transformation = new RedundantTransformation();
        }
        int n2 = n == 7 ? 4 : 3;
        HashMap<String, CCModel> hashMap = new HashMap<String, CCModel>();
        ArrayList<Vector3> arrayList = new ArrayList<Vector3>();
        ArrayList<Vector3> arrayList2 = new ArrayList<Vector3>();
        ArrayList<Vector3> arrayList3 = new ArrayList<Vector3>();
        ArrayList<int[]> arrayList4 = new ArrayList<int[]>();
        String string2 = "unnamed";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            Object[] objectArray;
            if ((string = string.replaceAll("\\s+", " ").trim()).startsWith("#") || string.length() == 0) continue;
            if (string.startsWith("v ")) {
                CCModel.assertMatch(vertMatcher, string);
                objectArray = CCModel.parseDoubles(string.substring(2), " ");
                CCModel.illegalAssert(objectArray.length >= 3, "Vertices must have x, y and z components");
                object = new Vector3(objectArray[0], objectArray[1], objectArray[2]);
                transformation.apply(object);
                arrayList.add((Vector3)object);
                continue;
            }
            if (string.startsWith("vt ")) {
                CCModel.assertMatch(uvwMatcher, string);
                objectArray = CCModel.parseDoubles(string.substring(3), " ");
                CCModel.illegalAssert(objectArray.length >= 2, "Tex Coords must have u, and v components");
                arrayList2.add(new Vector3(objectArray[0], 1.0 - objectArray[1], 0.0));
                continue;
            }
            if (string.startsWith("vn ")) {
                CCModel.assertMatch(normalMatcher, string);
                objectArray = CCModel.parseDoubles(string.substring(3), " ");
                CCModel.illegalAssert(objectArray.length >= 3, "Normals must have x, y and z components");
                object = new Vector3(objectArray[0], objectArray[1], objectArray[2]).normalize();
                transformation.applyN((Vector3)object);
                arrayList3.add((Vector3)object);
                continue;
            }
            if (string.startsWith("f ")) {
                CCModel.assertMatch(polyMatcher, string);
                objectArray = string.substring(2).split(" ");
                CCModel.illegalAssert(objectArray.length >= 3, "Polygons must have at least 3 vertices");
                object = new int[objectArray.length][3];
                for (int i = 0; i < objectArray.length; ++i) {
                    String[] stringArray = objectArray[i].split("/");
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (stringArray[j].length() <= 0) continue;
                        object[i][j] = Integer.parseInt(stringArray[j]);
                    }
                }
                if (n2 == 3) {
                    CCModel.triangulate(arrayList4, (int[][])object);
                } else {
                    CCModel.quadulate(arrayList4, (int[][])object);
                }
            }
            if (!string.startsWith("g ")) continue;
            if (!arrayList4.isEmpty()) {
                hashMap.put(string2, CCModel.createModel(arrayList, arrayList2, arrayList3, n, arrayList4));
                arrayList4.clear();
            }
            string2 = string.substring(2);
        }
        if (!arrayList4.isEmpty()) {
            hashMap.put(string2, CCModel.createModel(arrayList, arrayList2, arrayList3, n, arrayList4));
        }
        return hashMap;
    }

    public static void triangulate(List<int[]> list, int[][] nArray) {
        for (int i = 2; i < nArray.length; ++i) {
            list.add(nArray[0]);
            list.add(nArray[i]);
            list.add(nArray[i - 1]);
        }
    }

    public static void quadulate(List<int[]> list, int[][] nArray) {
        if (nArray.length == 4) {
            list.add(nArray[0]);
            list.add(nArray[3]);
            list.add(nArray[2]);
            list.add(nArray[1]);
        } else {
            for (int i = 2; i < nArray.length; ++i) {
                list.add(nArray[0]);
                list.add(nArray[i]);
                list.add(nArray[i - 1]);
                list.add(nArray[i - 1]);
            }
        }
    }

    public static Map<String, CCModel> parseObjModels(ResourceLocation resourceLocation) {
        return CCModel.parseObjModels(resourceLocation, 4, null);
    }

    public static Map<String, CCModel> parseObjModels(ResourceLocation resourceLocation, Transformation transformation) {
        try {
            return CCModel.parseObjModels(Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation).getInputStream(), 4, transformation);
        }
        catch (IOException iOException) {
            throw new RuntimeException("failed to load model: " + resourceLocation, iOException);
        }
    }

    public static Map<String, CCModel> parseObjModels(ResourceLocation resourceLocation, int n, Transformation transformation) {
        try {
            return CCModel.parseObjModels(Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation).getInputStream(), n, transformation);
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to load model: " + resourceLocation, exception);
        }
    }

    public static CCModel createModel(List<Vector3> list, List<Vector3> list2, List<Vector3> list3, int n, List<int[]> list4) {
        int n2;
        int n3 = n2 = n == 7 ? 4 : 3;
        if (list4.size() < n2 || list4.size() % n2 != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for model: " + list4.size());
        }
        boolean bl = list4.get(0)[2] > 0;
        CCModel cCModel = CCModel.newModel(n, list4.size());
        if (bl) {
            cCModel.getOrAllocate(CCRenderState.normalAttrib);
        }
        for (int i = 0; i < list4.size(); ++i) {
            int[] nArray = list4.get(i);
            Vector3 vector3 = list.get(nArray[0] - 1).copy();
            Vector3 vector32 = nArray[1] <= 0 ? new Vector3() : list2.get(nArray[1] - 1).copy();
            if (nArray[2] > 0 != bl) {
                throw new IllegalArgumentException("Normals are an all or nothing deal here.");
            }
            cCModel.verts[i] = new Vertex5(vector3, vector32.x, vector32.y);
            if (!bl) continue;
            cCModel.normals()[i] = list3.get(nArray[2] - 1).copy();
        }
        return cCModel;
    }

    private static <T> int addIndex(List<T> list, T t) {
        int n = list.indexOf(t) + 1;
        if (n == 0) {
            list.add(t);
            n = list.size();
        }
        return n;
    }

    private static String clean(double d) {
        return d == (double)((int)d) ? Integer.toString((int)d) : Double.toString(d);
    }

    public static void exportObj(Map<String, CCModel> map, PrintWriter printWriter) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList<int[]> arrayList4 = new ArrayList<int[]>();
        for (Map.Entry<String, CCModel> entry : map.entrySet()) {
            Object object;
            int n;
            printWriter.println("g " + entry.getKey());
            CCModel cCModel = entry.getValue();
            int n2 = arrayList.size();
            int n3 = arrayList2.size();
            int n4 = arrayList3.size();
            boolean bl = cCModel.normals() != null;
            arrayList4.clear();
            for (n = 0; n < cCModel.verts.length; ++n) {
                object = new int[bl ? 3 : 2];
                object[0] = CCModel.addIndex(arrayList, cCModel.verts[n].vec);
                object[1] = CCModel.addIndex(arrayList2, cCModel.verts[n].uv);
                if (bl) {
                    object[2] = CCModel.addIndex(arrayList3, cCModel.normals()[n]);
                }
                arrayList4.add((int[])object);
            }
            if (n2 < arrayList.size()) {
                printWriter.println();
                for (n = n2; n < arrayList.size(); ++n) {
                    object = (Vector3)arrayList.get(n);
                    printWriter.format("v %s %s %s\n", CCModel.clean(object.x), CCModel.clean(object.y), CCModel.clean(object.z));
                }
            }
            if (n3 < arrayList2.size()) {
                printWriter.println();
                for (n = n3; n < arrayList2.size(); ++n) {
                    object = (UV)arrayList2.get(n);
                    printWriter.format("vt %s %s\n", CCModel.clean(object.u), CCModel.clean(object.v));
                }
            }
            if (n4 < arrayList3.size()) {
                printWriter.println();
                for (n = n4; n < arrayList3.size(); ++n) {
                    object = (Vector3)arrayList3.get(n);
                    printWriter.format("vn %s %s %s\n", CCModel.clean(object.x), CCModel.clean(object.y), CCModel.clean(object.z));
                }
            }
            printWriter.println();
            for (n = 0; n < arrayList4.size(); ++n) {
                if (n % cCModel.vp == 0) {
                    printWriter.format("f", new Object[0]);
                }
                object = (int[])arrayList4.get(n);
                if (bl) {
                    printWriter.format(" %d/%d/%d", object[0], object[1], object[2]);
                } else {
                    printWriter.format(" %d/%d", object[0], object[1]);
                }
                if (n % cCModel.vp != cCModel.vp - 1) continue;
                printWriter.println();
            }
        }
    }

    public CCModel shrinkUVs(double d) {
        for (int i = 0; i < this.verts.length; i += this.vp) {
            int n;
            UV uV = new UV();
            for (n = 0; n < this.vp; ++n) {
                uV.add(this.verts[i + n].uv);
            }
            uV.multiply(1.0 / (double)this.vp);
            for (n = 0; n < this.vp; ++n) {
                Vertex5 vertex5 = this.verts[i + n];
                vertex5.uv.u = vertex5.uv.u + (vertex5.uv.u < uV.u ? d : -d);
                vertex5.uv.v = vertex5.uv.v + (vertex5.uv.v < uV.v ? d : -d);
            }
        }
        return this;
    }

    public CCModel sidedCopy(int n, int n2, Vector3 vector3) {
        return this.copy().apply(new TransformationList((Transformation)Rotation.sideRotations[n].inverse(), Rotation.sideRotations[n2]).at(vector3));
    }

    public static void copy(CCModel cCModel, int n, CCModel cCModel2, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            cCModel2.verts[n2 + n4] = cCModel.verts[n + n4].copy();
        }
        for (n4 = 0; n4 < cCModel.attributes.size(); ++n4) {
            if (cCModel.attributes.get(n4) == null) continue;
            CCRenderState.arrayCopy(cCModel.attributes.get(n4), n, cCModel2.getOrAllocate(CCRenderState.getAttribute(n4)), n2, n3);
        }
    }

    public static void generateSidedModels(CCModel[] cCModelArray, int n, Vector3 vector3) {
        for (int i = 0; i < 6; ++i) {
            if (i == n) continue;
            cCModelArray[i] = cCModelArray[n].sidedCopy(n, i, vector3);
        }
    }

    public static void generateSidedModelsH(CCModel[] cCModelArray, int n, Vector3 vector3) {
        for (int i = 2; i < 6; ++i) {
            if (i == n) continue;
            cCModelArray[i] = cCModelArray[n].sidedCopy(n, i, vector3);
        }
    }

    public CCModel backfacedCopy() {
        return CCModel.generateBackface(this, 0, this.copy(), 0, this.verts.length);
    }

    public static CCModel generateBackface(CCModel cCModel, int n, CCModel cCModel2, int n2, int n3) {
        int n4 = cCModel.vp;
        if (n % n4 != 0 || n2 % n4 != 0 || n3 % n4 != 0) {
            throw new IllegalArgumentException("Vertices do not align with polygons");
        }
        int[][] nArrayArray = new int[][]{{0, 0}, {1, n4 - 1}, {2, n4 - 2}, {3, n4 - 3}};
        for (int i = 0; i < n3; ++i) {
            int n5 = i / n4 * n4;
            int n6 = i % n4;
            int n7 = n2 + n5 + nArrayArray[n6][1];
            int n8 = n + n5 + nArrayArray[n6][0];
            cCModel2.verts[n7] = cCModel.verts[n8].copy();
            for (int j = 0; j < cCModel.attributes.size(); ++j) {
                if (cCModel.attributes.get(j) == null) continue;
                CCRenderState.arrayCopy(cCModel.attributes.get(j), n8, cCModel2.getOrAllocate(CCRenderState.getAttribute(j)), n7, 1);
            }
            if (cCModel2.normals() == null || cCModel2.normals()[n7] == null) continue;
            cCModel2.normals()[n7].negate();
        }
        return cCModel2;
    }

    public CCModel generateSidedParts(int n, Vector3 vector3) {
        if (this.verts.length % (6 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int n2 = this.verts.length / 6;
        for (int i = 0; i < 6; ++i) {
            if (i == n) continue;
            this.generateSidedPart(n, i, vector3, n2 * n, n2 * i, n2);
        }
        return this;
    }

    public CCModel generateSidedPartsH(int n, Vector3 vector3) {
        if (this.verts.length % (4 * this.vp) != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for sided part generation");
        }
        int n2 = this.verts.length / 4;
        for (int i = 2; i < 6; ++i) {
            if (i == n) continue;
            this.generateSidedPart(n, i, vector3, n2 * (n - 2), n2 * (i - 2), n2);
        }
        return this;
    }

    public CCModel generateSidedPart(int n, int n2, Vector3 vector3, int n3, int n4, int n5) {
        return this.apply(new TransformationList((Transformation)Rotation.sideRotations[n].inverse(), Rotation.sideRotations[n2]).at(vector3), n3, n4, n5);
    }

    public CCModel apply(Transformation transformation, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            this.verts[n2 + i] = this.verts[n + i].copy();
            this.verts[n2 + i].vec.apply(transformation);
        }
        Vector3[] vector3Array = this.normals();
        if (vector3Array != null) {
            for (int i = 0; i < n3; ++i) {
                vector3Array[n2 + i] = vector3Array[n + i].copy();
                transformation.applyN(vector3Array[n2 + i]);
            }
        }
        return this;
    }

    public static CCModel combine(Collection<CCModel> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        int n = 0;
        int n2 = -1;
        for (CCModel cCModel : collection) {
            if (n2 == -1) {
                n2 = cCModel.vertexMode;
            }
            if (n2 != cCModel.vertexMode) {
                throw new IllegalArgumentException("Cannot combine models with different vertex modes");
            }
            n += cCModel.verts.length;
        }
        CCModel cCModel = CCModel.newModel(n2, n);
        int n3 = 0;
        for (CCModel cCModel2 : collection) {
            CCModel.copy(cCModel2, 0, cCModel, n3, cCModel2.verts.length);
            n3 += cCModel2.verts.length;
        }
        return cCModel;
    }

    public CCModel twoFacedCopy() {
        CCModel cCModel = CCModel.newModel(this.vertexMode, this.verts.length * 2);
        CCModel.copy(this, 0, cCModel, 0, this.verts.length);
        return CCModel.generateBackface(cCModel, 0, cCModel, this.verts.length, this.verts.length);
    }

    @Override
    public CCModel copy() {
        CCModel cCModel = CCModel.newModel(this.vertexMode, this.verts.length);
        CCModel.copy(this, 0, cCModel, 0, this.verts.length);
        return cCModel;
    }

    public Vector3 collapse() {
        Vector3 vector3 = new Vector3();
        for (Vertex5 vertex5 : this.verts) {
            vector3.add(vertex5.vec);
        }
        vector3.multiply(1.0 / (double)this.verts.length);
        return vector3;
    }

    public CCModel zOffset(Cuboid6 cuboid6) {
        block8: for (int i = 0; i < this.verts.length; ++i) {
            Vertex5 vertex5 = this.verts[i];
            Vector3 vector3 = this.normals()[i];
            switch (CCModel.findSide(vector3)) {
                case 0: {
                    vertex5.vec.y += cuboid6.min.y;
                    continue block8;
                }
                case 1: {
                    vertex5.vec.y += cuboid6.max.y;
                    continue block8;
                }
                case 2: {
                    vertex5.vec.z += cuboid6.min.z;
                    continue block8;
                }
                case 3: {
                    vertex5.vec.z += cuboid6.max.z;
                    continue block8;
                }
                case 4: {
                    vertex5.vec.x += cuboid6.min.x;
                    continue block8;
                }
                case 5: {
                    vertex5.vec.x += cuboid6.max.x;
                }
            }
        }
        return this;
    }

    public static int findSide(Vector3 vector3) {
        if (vector3.y <= -0.99) {
            return 0;
        }
        if (vector3.y >= 0.99) {
            return 1;
        }
        if (vector3.z <= -0.99) {
            return 2;
        }
        if (vector3.z >= 0.99) {
            return 3;
        }
        if (vector3.x <= -0.99) {
            return 4;
        }
        if (vector3.x >= 0.99) {
            return 5;
        }
        return -1;
    }

    public Cuboid6 bounds() {
        Vector3 vector3 = this.verts[0].vec;
        Cuboid6 cuboid6 = new Cuboid6(vector3.copy(), vector3.copy());
        for (int i = 1; i < this.verts.length; ++i) {
            cuboid6.enclose(this.verts[i].vec);
        }
        return cuboid6;
    }

    private static class PositionNormalEntry {
        public Vector3 pos;
        public LinkedList<Vector3> normals = new LinkedList();

        public PositionNormalEntry(Vector3 vector3) {
            this.pos = vector3;
        }

        public boolean positionEqual(Vector3 vector3) {
            return this.pos.x == vector3.x && this.pos.y == vector3.y && this.pos.z == vector3.z;
        }

        public PositionNormalEntry addNormal(Vector3 vector3) {
            this.normals.add(vector3);
            return this;
        }
    }
}

